-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
		
		if not self.loaded then
			self.ascendActive = false
			self.descendActive = false
		end
		
    self.ascend:LinkToTarget("river")
	  self.ascend:LinkToTarget("floods")
    self.descend:LinkToTarget("river")
	  self.descend:LinkToTarget("floods")
    
    handler = Renderer:GetTimeOfDayHandler()
    --Debug:Log("Floods handler initialized")
  end  
  
  if handler then
    t = handler:GetDayTime()
    
    if t <= 0.32 or t > 0.68 and not self.ascendActive then
      Debug("Time = " .. t)
			self.ascendActive = true
			self.descendActive = false
      self.ascend:TriggerAllTargets()
    elseif t > 0.32 and t <= 0.68 and not self.descendActive then
			self.descendActive = true
			self.ascendActive = false
			self.descend:TriggerAllTargets()
    end
    
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
	  OnAfterSceneLoaded(self)
	  self.loaded = true
		self.ascendActive = ar:Read()
		self.descendActive = ar:Read()
	elseif (ar:IsSaving()) then
		ar:Write(self.ascendActive)
		ar:Write(self.descendActive)
  end  
end

function CreateTriggerSources(self)
  self:AddTriggerSource("ascend")
  self:AddTriggerSource("descend")
end
